<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(isset($pageTitle) ? $pageTitle : 'Team'); ?></h2>
                        <div class="d-flex align-items-center">
                            <a href="<?php echo e(route('teamCategoryList')); ?>" class="btn list-button px-3 mr-2"><?php echo e(__('Team Category')); ?></a>
                            <a href="<?php echo e(route('teamCreate')); ?>" class="btn list-add-button px-3"><?php echo e(__('Add New')); ?></a>
                            <span class="sidebarToggler ml-4">
                                <i class="fa fa-bars d-lg-none d-block"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <table id="table" class="table category-table table-bordered  text-center mb-0">
                                <thead>
                                <tr>
                                    <th class="all"><?php echo e(__('Image')); ?></th>
                                    <th class="all"><?php echo e(__('Name')); ?></th>
                                    <th class="desktop"><?php echo e(__('Designation')); ?></th>
                                    <th class="desktop"><?php echo e(__('Category')); ?></th>
                                    <th class="desktop"><?php echo e(__('Added On')); ?></th>
                                    <th class="desktop"><?php echo e(__('Status')); ?></th>
                                    <th class="all"><?php echo e(__('Action')); ?></th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('#table').DataTable({
            processing: true,
            serverSide: true,
            pageLength: 25,
            responsive: true,
            ajax: '<?php echo e(route('teamList')); ?>',
            order: [5, 'desc'],
            autoWidth:false,
            columns: [
                {"data": "image"},
                {"data": "name"},
                {"data": "designation"},
                {"data": "category_id"},
                {"data": "created_at"},
                {"data": "status"},
                {"data": "actions",orderable: false, searchable: false}
            ]
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/workaholic/cms.workaholic.icu/resources/views/admin/team/list.blade.php ENDPATH**/ ?>