<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?></h2>
                        <span class="sidebarToggler">
                            <i class="fa fa-bars d-lg-none d-block"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card qz-profile-area">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-5 col-lg-5">
                            <div class="qz-profile-card text-center">
                                <div class="qz-edit-icon">
                                    <a href="<?php echo e(route('editUser', encrypt($user->id))); ?>">
                                        <img src="<?php echo e(asset('assets/images/edit.png')); ?>" alt="" class="img-fluid">
                                    </a>
                                </div>
                                <div class="qz-profile-user-avater">
                                    <img <?php if(isset($user->photo)): ?> src="<?php echo e(asset(path_user_image().$user->photo)); ?>" <?php else: ?> src="<?php echo e(asset('assets/images/avater.jpg')); ?>" <?php endif; ?> alt="" class="img-fluid">
                                </div>
                                <div class="qz-user-info">
                                    <h4> $user->name }}</h4>
                                    <p><?php echo clean($user->email); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-7 col-lg-7">
                            <ul class="user-details-info mt-md-0 mt-4">
                                <li>
                                    <div class="row ">
                                        <div class="col-4"><?php echo e(__('Name')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo clean($user->name); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('Phone')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo clean($user->phone); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('Country')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo e(isset($user->country) ? country($user->country) : ''); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('City')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo clean($user->city); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('State')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo clean($user->state); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('Zip')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col"><?php echo clean($user->zip); ?></div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row">
                                        <div class="col-4"><?php echo e(__('Full Address')); ?></div>
                                        <div class="col-1">:</div>
                                        <div class="col-md-7 col-6"><?php echo clean($user->address); ?></div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/workaholic/cms.workaholic.icu/resources/views/admin/user/user-profile.blade.php ENDPATH**/ ?>