<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo e(__('Login')); ?></title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/font-awesome.min.css')); ?>">
    <!-- Owl Carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.theme.default.min.css')); ?>">
    <!-- magnific popup -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/magnific-popup.css')); ?>">
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/swiper-master/css/swiper.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/iconfont/flaticon.css')); ?>">
    <!-- font family -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/proxima-nova.css')); ?>">
    <!-- Site Style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>">
    <!-- Modernizr Js -->
    <script src="<?php echo e(asset('assets/vendors/modernizr-js/modernizr.js')); ?>"></script>
    <!--[if lt IE 8]>
    <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
</head>

<body class="user-body">


<!-- Start user area -->
<div class="container">
    <div class="row">
        <div class="col-lg-8 offset-2">
            <div class="card">
                <div class="card">
                    <div class="card-body">
                        <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-lg-8 offset-2">
                            <div class="logo">
                                <a href="#">
                                    <img <?php if(!empty(allsetting('login_logo'))): ?> src ="<?php echo e(asset(path_image().allsetting('login_logo'))); ?>" <?php else: ?> src="<?php echo e(asset('assets/images/logo.png')); ?>" <?php endif; ?>  alt="" class="img-fluid">
                                </a>
                            </div>
                            <div class="qz-user-title">
                                <h1><?php echo e(__('Sign in')); ?></h1>
                            </div>
                            <h5>
                                <?php if(isset(allsetting()['login_text']) && (!empty(allsetting('login_text')))): ?>
                                    <?php echo e(allsetting('login_text')); ?>

                                <?php else: ?>
                                    <?php echo e(__('Hello there, Sign in and start managing your Admin Template')); ?>

                                <?php endif; ?>
                            </h5>

                            <?php echo e(Form::open(['route' => 'postLogin'])); ?>

                            <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <input type="email" name="email" class="form-control" placeholder="Enter email">
                                    <div class="qz-input-icon">
                                        <span class="flaticon-mail"></span>
                                    </div>
                                </div>
                                <span class="text-danger"><strong><?php echo e($errors->first('email')); ?></strong></span>
                                <div class="form-group">
                                    <input type="password" name="password" class="form-control" placeholder="Password">
                                    <div class="qz-input-icon">
                                        <span class="flaticon-lock"></span>
                                    </div>
                                </div>
                                <span class="text-danger"><strong><?php echo e($errors->first('password')); ?></strong></span>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Sign in')); ?></button>
                            <?php echo e(Form::close()); ?>


                            <div class="qz-user-footer">
                                <h4><a href="<?php echo e(route('forgetPassword')); ?>"><?php echo e(__('Forgot Password ?')); ?></a> </h4>
                                <h5><a href="<?php echo e(route('privacyPolicy')); ?>"><?php echo e(__('Privacy Policy')); ?></a> and <a href="<?php echo e(route('termsCondition')); ?>"><?php echo e(__('Terms & Conditions')); ?></a> </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- End user area -->



<!-- Jquery plugins -->
<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/popper.min.js')); ?>" ></script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
<!-- Owl Carousel -->
<script src="<?php echo e(asset('assets/js/owl.carousel.min.js')); ?>"></script>
<!-- Counterup -->
<script src="<?php echo e(asset('assets/js/waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/counterup.min.js')); ?>"></script>
<!-- Slicknav -->
<script src="<?php echo e(asset('assets/js/metisMenu.min.js')); ?>"></script>
<!-- magnific popup -->
<script src="<?php echo e(asset('assets/js/magnific-popup.min.js')); ?>"></script>
<!-- Swiper Slider -->
<script src="<?php echo e(asset('assets/vendors/swiper-master/js/swiper.min.js')); ?>"></script>
<!-- main js -->
<script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
</body>

</html>
<?php /**PATH /home/workaholic/cms.workaholic.icu/resources/views/auth/signin.blade.php ENDPATH**/ ?>