<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(isset($pageTitle) ? $pageTitle : ''); ?></h2>
                        <span class="sidebarToggler">
                            <i class="fa fa-bars d-lg-none d-block"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card add-category">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo e(Form::open(['route' => 'planSave', 'files' => 'true'])); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('title') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Plan Title')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="title" <?php if(isset($item)): ?> value="<?php echo e($item->title); ?>" <?php else: ?> value="<?php echo e(old('title')); ?>"
                                               <?php endif; ?> class="form-control" placeholder="<?php echo e(__('Plan title')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('title')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('price') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Price')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="price" <?php if(isset($item)): ?> value="<?php echo e($item->price); ?>" <?php else: ?> value="<?php echo e(old('price')); ?>"
                                               <?php endif; ?> class="form-control" placeholder="<?php echo e(__('Pricing Price')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('price')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Duration')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="duration" class="form-control">
                                                <?php $__currentLoopData = plan_duration(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($item) && ($item->duration == $key)): ?> selected <?php elseif((old('duration') != null) && (old('duration') == $key)): ?> <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('duration')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Status')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="status" class="form-control">
                                                <?php $__currentLoopData = status(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($item) && ($item->status == $key)): ?> selected <?php elseif((old('status') != null) && (old('status') == $key)): ?> <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('status')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(__('Description')); ?></label>
                                        <textarea name="description" id="" rows="4" class="form-control"><?php if(isset($item)): ?><?php echo e($item->description); ?><?php else: ?><?php echo e(old('description')); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-9">
                                    <div class="form-group">
                                        <label><?php echo e(__('Feature')); ?><span style="color:red;">*</span></label>
                                        <input type="text" name="features" value="" id="price" class="form-control"/>
                                        <span class="text-danger"><strong><?php echo e($errors->first('features')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?php echo e(__('Add Remove')); ?></label><br>
                                        <input type="button" name="reset" class="btn btn-info" onclick="AddOptionRow();" value="+">
                                        <input type="button" name="add" class="btn btn-danger" onclick="removeOptionRow();" value="-">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <input type="hidden" name="option_count" id="option_count" value="1">
                                    <input type="hidden" name="option_counts" id="option_counts">
                                    <table class="table table-bordered" id="first" border="1">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('Feature List')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(isset($plan_features[0])): ?>
                                            <?php ($i=1); ?>
                                            <?php $__currentLoopData = $plan_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan_feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="text" value="<?php echo e($plan_feature->title); ?>" name="features[]" id="price<?php echo e($i); ?>" class="form-control">
                                                    </td>
                                                </tr>
                                                <?php ($i++); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        </tbody>

                                    </table>
                                    <pre class="text-danger"><?php echo e($errors->first('option_id')); ?></pre>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <?php if(isset($item)): ?>
                                        <input type="hidden" name="edit_id" value="<?php echo e($item->id); ?>">
                                    <?php endif; ?>
                                    <button type="submit" class="btn btn-primary btn-block add-category-btn">
                                        <?php if(isset($item)): ?> <?php echo e(__('Update')); ?> <?php else: ?> <?php echo e(__('Add New')); ?> <?php endif; ?>
                                    </button>
                                </div>
                            </div>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        // for adding option
        var option_data = [];
        function AddOptionRow()
        {
            var option_id = $('#price').val();

            if($('#price').val()=="")
            {
                alertify.error("Feature is required");
            }
            else if(in_array(option_id,option_data))
            {
                alertify.error("Already existed");
            }
            else
            {
                var cnt=$("#option_count").val();
                var ncnt = cnt;
                var sno = cnt;
                $('#first tr').last().after('<tr><td><input  type="text" value="'+$('#price').val()+'" name="features[]" id="price'+ncnt+'" class="form-control"></td></tr>');
                cnt=++cnt;
                $("#option_count").val(cnt);
                $("#option_counts").val(cnt);
                option_data.push(option_id);
            }
        }

        //
        function in_array(search, array)
        {
            for (i = 0; i < array.length; i++)
            {
                if(array[i] == search )
                {
                    return true;
                }
            }
            return false;
        }
        // remove option
        function removeOptionRow()
        {
            table = document.getElementById("first");
            var rowno = table.rows.length;

            if(table.rows.length > 1)
            {
                var cnt=$("#option_count").val();
                var ncnt = --cnt;
                var option_id = $('#price'+ncnt).val();

                option_data = jQuery.grep(option_data, function(value) {
                    return value != option_id;
                });

                $('#first tr:last-child').remove();
                $("#option_count").val(ncnt);
                $("#option_counts").val(ncnt);
            }
            $("#option_counts").val("");
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ayara/resources/views/admin/plan/add.blade.php ENDPATH**/ ?>