<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(isset($pageTitle) ? $pageTitle : ''); ?></h2>
                        <span class="sidebarToggler">
                            <i class="fa fa-bars d-lg-none d-block"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card add-category">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo e(Form::open(['route' => 'portfolioSave', 'files' => 'true'])); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('title') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Portfolio Title')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="title" <?php if(isset($item)): ?> value="<?php echo e($item->title); ?>" <?php else: ?> value="<?php echo e(old('title')); ?>"
                                               <?php endif; ?> class="form-control" placeholder="<?php echo e(__('Portfolio Title')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('title')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Category')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="category_id" class="form-control">
                                                <option value=""><?php echo e(__('Select')); ?></option>
                                                <?php if(isset($categories[0])): ?>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if(isset($item) && ($item->category_id == $key->id)): ?> selected <?php elseif((old('category_id') != null) && (old('category_id') == $key->id)): ?> <?php endif; ?> value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('category_id')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('client') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Client')); ?><span class="text-danger"></span></label>
                                        <input type="text" name="client" <?php if(isset($item)): ?> value="<?php echo e($item->client); ?>" <?php else: ?> value="<?php echo e(old('client')); ?>" <?php endif; ?>
                                            class="form-control" placeholder="<?php echo e(__('Client Name')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('client')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('date') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Date')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="date" <?php if(isset($item)): ?> value="<?php echo e($item->date); ?>" <?php else: ?> value="<?php echo e(old('date')); ?>"
                                               <?php endif; ?> class="form-control datepicker" placeholder="<?php echo e(__('YYYY-MM-DD')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('date')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group <?php echo e($errors->has('demo') ? ' has-error' : ''); ?>">
                                        <label><?php echo e(__('Demo Link')); ?><span class="text-danger"></span></label>
                                        <input type="text" name="demo" <?php if(isset($item)): ?> value="<?php echo e($item->demo); ?>" <?php else: ?> value="<?php echo e(old('demo')); ?>"
                                               <?php endif; ?> class="form-control" placeholder="<?php echo e(__('Demo Link')); ?>">
                                        <span class="text-danger"><strong><?php echo e($errors->first('demo')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Status')); ?><span class="text-danger">*</span></label>
                                        <div class="qz-question-category">
                                            <select name="status" class="form-control">
                                                <?php $__currentLoopData = status(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(isset($item) && ($item->status == $key)): ?> selected <?php elseif((old('status') != null) && (old('status') == $key)): ?> <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <span class="text-danger"><strong><?php echo e($errors->first('status')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(__('Description')); ?><span class="text-danger">*</span></label>
                                        <textarea name="description" id="" rows="6" class="form-control"><?php if(isset($item)): ?><?php echo e($item->description); ?><?php else: ?><?php echo e(old('description')); ?><?php endif; ?></textarea>
                                        <span class="text-danger"><strong><?php echo e($errors->first('description')); ?></strong></span>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(__('Experience')); ?></label>
                                        <textarea name="experience" id="" rows="6" class="form-control"><?php if(isset($item)): ?><?php echo e($item->experience); ?><?php else: ?><?php echo e(old('experience')); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-4">
                                    <label><?php echo e(__('Image')); ?></label><br>
                                    <div class="drag_img_wrapper">
                                        <label for="uploadimage">
                                            <i class="fa fa-cloud-upload"></i>
                                        </label>
                                        <div class="d-none">
                                            <input type="file" id="uploadimage" name="image[]" multiple onchange="readURL(this,'image')">
                                        </div>
                                    </div>
                                    <pre class="text-danger"><?php echo e($errors->first('image.*')); ?></pre>
                                </div>
                                <div class="col-sm-8 col-8" id="imgs">
                                    <?php if(isset($item)): ?>
                                        <?php ($n= 1); ?>
                                        <?php $__currentLoopData = $item->image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="product-imgs" id="row<?php echo e($n); ?>">
                                                <img width="" src="<?php echo e($img); ?>" />
                                                <i class="fa fa-times remove-uploaded-img" data-src="<?php echo e($img); ?>" id="<?php echo e($n); ?>"></i>
                                            </div>
                                            <?php ($n++); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <?php if(isset($item)): ?>
                                        <input type="hidden" name="edit_id" value="<?php echo e($item->id); ?>">
                                    <?php endif; ?>
                                    <button type="submit" class="btn btn-primary btn-block add-category-btn">
                                        <?php if(isset($item)): ?> <?php echo e(__('Update')); ?> <?php else: ?> <?php echo e(__('Add New')); ?> <?php endif; ?>
                                    </button>
                                </div>
                            </div>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function readURL(input,name) {
            var n=1;
            if (input.files && input.files[0]) {
                var fileList=input.files;
                for(var i = 0; i < fileList.length; i++)
                {
                    //get a blob
                    var t = window.URL || window.webkitURL;
                    var objectUrl = t.createObjectURL(fileList[i]);
                    $('#imgs').append('<div class="product-imgs"><img width="100" src="' + objectUrl + '" /></div>');
                }
            }
        }
        $(document).on('click', '.remove-imgs', function(){
            var remove_id = $(this).attr("id");
            $('#rows'+remove_id+'').remove();
        });

        $(document).on('click', '.remove-uploaded-img', function(){

            id = <?php echo (!empty($item) ? $item->id : '""'); ?>;
            var src = $(this).data("src");
            var t =src.split("/");
            imgSrc = t[t.length-1];

            $.ajax({
                type: "GET",
                url: '<?php echo e(route('deleteUploadedImage')); ?>',
                data: {
                    '_token': '<?php echo e(csrf_token()); ?>',
                    'id': id,
                    'src': imgSrc,
                },
                success: function (data) {
                    console.log(data['data']['updateData']);
                }
            });
            var remove_id = $(this).attr("id");
            $('#row'+remove_id+'').remove();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/workaholic/cms.workaholic.icu/resources/views/admin/portfolio/add.blade.php ENDPATH**/ ?>