<?php $__env->startSection('title'); ?> <?php if(isset($pageTitle)): ?> <?php echo e($pageTitle); ?> <?php endif; ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(isset($pageTitle) ? $pageTitle : 'Frontend Menu'); ?></h2>
                        <div class="d-flex align-items-center">
                            <a href="<?php echo e(route('menuCreate')); ?>" class="btn list-add-button px-3"><?php echo e(__('Add New')); ?></a>
                            <span class="sidebarToggler ml-4">
                                <i class="fa fa-bars d-lg-none d-block"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->
    <?php echo $__env->make('layout.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <table id="table" class="table category-table table-bordered  text-center mb-0">
                                <thead>
                                <tr>
                                    <th class="all"><?php echo e(__('Menu Title')); ?></th>
                                    <th class="desktop"><?php echo e(__('Slug')); ?></th>
                                    <th class="desktop"><?php echo e(__('Component')); ?></th>
                                    <th class="desktop"><?php echo e(__('Status')); ?></th>
                                    <th class="desktop"><?php echo e(__('Added On')); ?></th>
                                    <th class="all"><?php echo e(__('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody id="sortable"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('#table').DataTable({
            processing: true,
            serverSide: true,
            pageLength: 25,
            responsive: true,
            ajax: '<?php echo e(route('menuList')); ?>',
            order: [4, 'desc'],
            autoWidth:false,
            columns: [
                {"data": "title"},
                {"data": "slug"},
                {"data": "component"},
                {"data": "status"},
                {"data": "created_at"},
                {"data": "actions",orderable: false, searchable: false}
            ]
        });
    </script>
    <script src="<?php echo e(asset('assets/customMenu/jquery-1.12.4.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/customMenu/jquery-ui.js')); ?>"></script>
    <script>
        $( function() {
            $( "#sortable" ).sortable();
            $( "#sortable" ).disableSelection();
        } );

        $( "#sortable" ).sortable({

            update: function( ) {
                var l_ar = [];
                $( ".shortable_data" ).each(function( index,data ) {
                    l_ar.push($(this).val());
                });

                $.get( "<?php echo e(route('customMenuOrder')); ?>?vals="+l_ar, function( data ) {
                    $( ".result" ).html( data );
                    VanillaToasts.create({
                        //  title: 'Message Title',
                        text:data.message,
                        backgroundColor: "linear-gradient(135deg, #73a5ff, #5477f5)",
                        type: 'success',
                        timeout: 3000
                    });
                });
            }
        });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ayara/resources/views/admin/setting/menu/list.blade.php ENDPATH**/ ?>